/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/
package shared;

import java.io.*;

/**
 * A utility for viewing the contents of a <code>PAM</code> file.
 * 
 * @author Jason Howes
 * @version 1.0, 2/21/1999
 * @see cnrg.apps.spot.shared.PAMDescriptorEntry
 * @see cnrg.apps.spot.shared.PAMTopicIndexEntry
 * @see cnrg.apps.spot.shared.PAM
 */
public class PAMViewer
{
	/**
	 * Main entry point of the <code>PAMViewer</code> utility.
	 * <p> Usage:
	 * <p> PAMViewer [filename][?]
	 * 
	 * @param args the command line arguments.
	 */
	public static void main(String[] args)
	{
		FileInputStream fileInput;
		ObjectInputStream objectInput;
		PAM pam;

		// Test for arguments
		if (args.length >= 1)
		{
			if (args[0].compareTo("?") == 0)
			{
				System.out.println("Usage : PAMViewer [filename][?]");
				return;
			}
		}

		// Print some info
		System.out.println("PAMViewer:\n\n");

		// Open the PAM file
		try
		{
			fileInput = new FileInputStream(args[0]);
			objectInput = new ObjectInputStream(fileInput);
			
			pam = (PAM)objectInput.readObject();
			pam.print();

			objectInput.close();
			fileInput.close();

			System.out.println("\nPress enter...");

			(new BufferedReader(new InputStreamReader(System.in))).readLine();
		}
		catch (Exception e)
		{
			System.out.println("Sorry - an exception occured: " + e.getMessage());
		}
	}
}